####################################################################################################

#   Copyright (C) 2021 Dominique PUNSOLA

#   This file is part of Cognatus.
# 
#   Cognatus is free software: you can redistribute it and modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
# 
#   Cognatus is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with Cognatus.  If not, see <https://www.gnu.org/licenses/>.

####################################################################################################

#   Copyright (C) 2021 Dominique PUNSOLA

#   Ce fichier est une partie de Cognatus.
#   
#   Cognatus est un logiciel libre ; vous pouvez le redistribuer et le modifier 
#   au titre des clauses de la Licence Publique Gnrale GNU, telle que publie par 
#   la Free Software Foundation ; soit la version 3 de la Licence, ou 
#   ( votre discrtion) une version ultrieure quelconque. 
#   
#   Cognatus est distribu dans l'espoir qu'il sera utile, 
#   mais SANS AUCUNE GARANTIE ; sans mme une garantie implicite de 
#   COMMERCIABILITE ou DE CONFORMITE A UNE UTILISATION PARTICULIERE. Voir la 
#   Licence Publique Gnrale GNU pour plus de dtails. 
#   
#   Vous devriez avoir reu un exemplaire de la Licence Publique Gnrale GNU 
#   avec Cognatus ; si ce n'est pas le cas, voyez <https://www.gnu.org/licenses/>.

####################################################################################################
# mode debug

Set-StrictMode -Version 3

Add-Type -Name Window -Namespace Console -MemberDefinition '
[DllImport("Kernel32.dll")]
public static extern IntPtr GetConsoleWindow();
[DllImport("user32.dll")]
public static extern bool ShowWindow(IntPtr hWnd, Int32 nCmdShow);
'

####################################################################################################
# Assembly

Add-Type -AssemblyName System.Windows.Forms 
Add-Type -AssemblyName System.Drawing
[System.Windows.Forms.Application]::EnableVisualStyles()

$assemblyFile = (Resolve-Path ("System.Data.SQLite.dll")).path
[Reflection.Assembly]::LoadFile($assemblyFile) | Out-Null

####################################################################################################
# cration d'une base en mmoire
$global:conn_mem = New-Object -TypeName System.Data.SQLite.SQLiteConnection
$global:conn_mem.ConnectionString = "Data Source=" + ":memory:"
$global:conn_mem.Open()


####################################################################################################
# langue
$langue = (Get-WinSystemLocale).name.split('-')[0]
# $langue = "nl"

####################################################################################################
# tables de libells

if ($langue -eq "es") {
$table_lib=@{}
$table_lib.add(1,"Calendario republicano (versin 1.3)")
$table_lib.add(2,"Fecha republicana")
$table_lib.add(3,"Fecha gregoriana")
$table_lib.add(4,"Convertir")
$table_lib.add(5,"")
$table_lib.add(6,"Fuente")
$table_lib.add(7,"")
$table_lib.add(8,"Mostrar menos")
$table_lib.add(9,"Mostrar ms")
} elseif ($langue -eq "it") {
$table_lib=@{}
$table_lib.add(1,"Calendario repubblicano (versione 1.3)")
$table_lib.add(2,"Data repubblicana")
$table_lib.add(3,"Data gregoriana")
$table_lib.add(4,"Converti")
$table_lib.add(5,"")
$table_lib.add(6,"Fonte")
$table_lib.add(7,"")
$table_lib.add(8,"Mostra meno")
$table_lib.add(9,"Mostrar piu")
} elseif ($langue -eq "de") {
$table_lib=@{}
$table_lib.add(1,"Republikanischer Kalender (Version 1.3)")
$table_lib.add(2,"Republikanisches")
$table_lib.add(3,"Gregorianisches")
$table_lib.add(4,"Konvertieren")
$table_lib.add(5,"")
$table_lib.add(6,"Quelle")
$table_lib.add(7,"")
$table_lib.add(8,"Weniger anzeigen")
$table_lib.add(9,"Mehr anzeigen")
} elseif ($langue -eq "nl") {
$table_lib=@{}
$table_lib.add(1,"Republikeinse kalender (versie 1.3)")
$table_lib.add(2,"Republikeins")
$table_lib.add(3,"Gregoriaans")
$table_lib.add(4,"Converteren")
$table_lib.add(5,"")
$table_lib.add(6,"Bron")
$table_lib.add(7,"")
$table_lib.add(8,"Toon minder")
$table_lib.add(9,"Toon meer")
} else {
$table_lib=@{}
$table_lib.add(1,"Calendrier rpublicain (version 1.3)")
$table_lib.add(2,"Date rpublicaine : ")
$table_lib.add(3,"Date grgorienne : ")
$table_lib.add(4,"Convertir")
$table_lib.add(5,"")
$table_lib.add(6,"Source")
$table_lib.add(7,"")
$table_lib.add(8,"Afficher moins")
$table_lib.add(9,"Afficher plus")
}

####################################################################################################
# tables de mois
if ($langue -eq "es") {
$table_mois=@{}
$table_mois.add(1,"Enero")
$table_mois.add(2,"Febrero")
$table_mois.add(3,"Marzo")
$table_mois.add(4,"Abril")
$table_mois.add(5,"Mayo")
$table_mois.add(6,"Junio")
$table_mois.add(7,"Julio")
$table_mois.add(8,"Agosto")
$table_mois.add(9,"Septiembre")
$table_mois.add(10,"Octubre")
$table_mois.add(11,"Noviembre")
$table_mois.add(12,"Diciembre")
} elseif ($langue -eq "it") {
$table_mois=@{}
$table_mois.add(1,"Gennaio")
$table_mois.add(2,"Febbraio")
$table_mois.add(3,"Marzo")
$table_mois.add(4,"Aprile")
$table_mois.add(5,"Maggio")
$table_mois.add(6,"Giugno")
$table_mois.add(7,"Luglio")
$table_mois.add(8,"Agosto")
$table_mois.add(9,"Settembre")
$table_mois.add(10,"Ottobre")
$table_mois.add(11,"Novembre")
$table_mois.add(12,"Dicembre")
} elseif ($langue -eq "de") {
$table_mois=@{}
$table_mois.add(1,"Januar")
$table_mois.add(2,"Februar")
$table_mois.add(3,"Mrz")
$table_mois.add(4,"April")
$table_mois.add(5,"Mai")
$table_mois.add(6,"Juni")
$table_mois.add(7,"Juli")
$table_mois.add(8,"August")
$table_mois.add(9,"September")
$table_mois.add(10,"Oktober")
$table_mois.add(11,"November")
$table_mois.add(12,"Dezember")
} elseif ($langue -eq "nl") {
$table_mois=@{}
$table_mois.add(1,"Januari")
$table_mois.add(2,"Februari")
$table_mois.add(3,"Maart")
$table_mois.add(4,"April")
$table_mois.add(5,"Mei")
$table_mois.add(6,"Juni")
$table_mois.add(7,"Juli")
$table_mois.add(8,"Augustus")
$table_mois.add(9,"September")
$table_mois.add(10,"Oktober")
$table_mois.add(11,"November")
$table_mois.add(12,"Dezember")
} else {
$table_mois=@{}
$table_mois.add(1,"Janvier")
$table_mois.add(2,"Fvrier")
$table_mois.add(3,"Mars")
$table_mois.add(4,"Avril")
$table_mois.add(5,"Mai")
$table_mois.add(6,"Juin")
$table_mois.add(7,"Juillet")
$table_mois.add(8,"Aot")
$table_mois.add(9,"Septembre")
$table_mois.add(10,"Octobre")
$table_mois.add(11,"Novembre")
$table_mois.add(12,"Dcembre")
}

####################################################################################################
# calendrier rpublicain
$CalRepForm = New-Object System.Windows.Forms.Form -Property @{width = "450" ; height = "320" ; ControlBox = $true ; ShowInTaskBar = $true ; FormBorderStyle = "Fixed3D"
text = $table_lib[1] ; Icon = [System.Drawing.Icon]::ExtractAssociatedIcon((Resolve-Path ("cal_rep_1.ico")).path)}
$CalRepToolTip     = New-Object System.Windows.Forms.ToolTip

############################# date rpublicaine
$CalRepDateRlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 14" ; Size = "100, 18" ; Text = $table_lib[2] ; TextAlign="MiddleLeft"}
$CalRepForm.Controls.Add($CalRepDateRlabel)
$CalRepJourR     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "110, 13" ; width = "40" ; DropDownStyle = "DropDown" ; MaxDropDownItems = 35}
$CalRepForm.Controls.Add($CalRepJourR)
for($i = 1;$i -lt 31;$i++) {[void]$CalRepJourR.Items.add($i)}
$CalRepJourR.text = "1"
$CalRepMoisR     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "160, 13" ; width = "100" ; DropDownStyle = "DropDownList"}
$CalRepForm.Controls.Add($CalRepMoisR)
[void]$CalRepMoisR.Items.add("")
[void]$CalRepMoisR.Items.add("Vendmiaire")
[void]$CalRepMoisR.Items.add("Brumaire")
[void]$CalRepMoisR.Items.add("Frimaire")
[void]$CalRepMoisR.Items.add("Nivse")
[void]$CalRepMoisR.Items.add("Pluvise")
[void]$CalRepMoisR.Items.add("Ventse")
[void]$CalRepMoisR.Items.add("Germinal")
[void]$CalRepMoisR.Items.add("Floral")
[void]$CalRepMoisR.Items.add("Prairial")
[void]$CalRepMoisR.Items.add("Messidor")
[void]$CalRepMoisR.Items.add("Thermidor")
[void]$CalRepMoisR.Items.add("Fructidor")
[void]$CalRepMoisR.Items.add("Complmentaire")
$CalRepMoisR.text = "Vendmiaire"
$CalRepAnR     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "270, 13" ; width = "60" ; DropDownStyle = "DropDownList"}
$CalRepForm.Controls.Add($CalRepAnR)
[void]$CalRepAnR.Items.add("")
[void]$CalRepAnR.Items.add("an I")
[void]$CalRepAnR.Items.add("an II")
[void]$CalRepAnR.Items.add("an III")
[void]$CalRepAnR.Items.add("an IV")
[void]$CalRepAnR.Items.add("an V")
[void]$CalRepAnR.Items.add("an VI")
[void]$CalRepAnR.Items.add("an VII")
[void]$CalRepAnR.Items.add("an VIII")
[void]$CalRepAnR.Items.add("an IX")
[void]$CalRepAnR.Items.add("an X")
[void]$CalRepAnR.Items.add("an XI")
[void]$CalRepAnR.Items.add("an XII")
[void]$CalRepAnR.Items.add("an XIII")
[void]$CalRepAnR.Items.add("an XIV")
$CalRepAnR.text = "an I"

$CalRepModifR     = New-Object System.Windows.Forms.TextBox -Property @{Location = "321, 13" ; Size = "18, 18" ; text = "y" ; visible = $false}
$CalRepForm.Controls.Add($CalRepModifR)
$CalRepJourR.add_textchanged({modifr})
$CalRepJourR.add_selectedvaluechanged({modifr})
$CalRepMoisR.add_textchanged({modifr})
$CalRepMoisR.add_selectedvaluechanged({modifr})
$CalRepAnR.add_textchanged({modifr})
$CalRepAnR.add_selectedvaluechanged({modifr})

$CalRepRversG      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 13" ; Text = $table_lib[4]}
$CalRepRversG.add_Click({RversG}) ; $CalRepForm.Controls.Add($CalRepRversG)

############################# date grgorienne
$CalRepDateGlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 44" ; Size = "100, 18" ; Text = $table_lib[3] ; TextAlign="MiddleLeft"}
$CalRepForm.Controls.Add($CalRepDateGlabel)
$CalRepJourG     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "110, 43" ; width = "40" ; DropDownStyle = "DropDown" ; MaxDropDownItems = 35}
$CalRepForm.Controls.Add($CalRepJourG)
for($i = 1;$i -lt 32;$i++) {[void]$CalRepJourG.Items.add($i)}
$CalRepJourG.text = "22"
$CalRepMoisG     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "160, 43" ; width = "100" ; DropDownStyle = "DropDownList"}
$CalRepForm.Controls.Add($CalRepMoisG)
[void]$CalRepMoisG.Items.add("")
for($i = 1;$i -lt 13;$i++) {[void]$CalRepMoisG.Items.add($table_mois[$i])}
$CalRepMoisG.text = $table_mois[9]
$CalRepAnG     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "270, 43" ; width = "60" ; DropDownStyle = "DropDownList"}
$CalRepForm.Controls.Add($CalRepAnG)
[void]$CalRepAnG.Items.add("")
for($i = 0;$i -lt 14;$i++) {[void]$CalRepAnG.Items.add($i + 1792)}
$CalRepAnG.text = 1792

$CalRepModifG     = New-Object System.Windows.Forms.TextBox -Property @{Location = "321, 43" ; Size = "18, 18" ; text = "y" ; visible = $false}
$CalRepForm.Controls.Add($CalRepModifG)
$CalRepJourG.add_textchanged({modifg})
$CalRepJourG.add_selectedvaluechanged({modifg})
$CalRepMoisG.add_textchanged({modifg})
$CalRepMoisG.add_selectedvaluechanged({modifg})
$CalRepAnG.add_textchanged({modifg})
$CalRepAnG.add_selectedvaluechanged({modifg})

$CalRepGversR      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 43" ; Text = $table_lib[4]}
$CalRepGversR.add_Click({GversR}) ; $CalRepForm.Controls.Add($CalRepGversR)


############################# objet calendrier
$calendar = New-Object Windows.Forms.MonthCalendar -Property @{Location = "108, 75" ; ShowTodayCircle = $false ; MaxSelectionCount = 1 ; name = "y" ; ShowToday = $false}
$CalRepForm.Controls.Add($calendar)
$calendar.MaxDate = new-object System.DateTime(1805, 12, 31)
$calendar.MinDate = new-object System.DateTime(1792, 09, 22)
$calendar.SelectionStart = new-object System.DateTime(1792, 09, 22)

$calendar.add_dateChanged({
if ($Calendar.name -eq "y") {
$CalRepModifG.text = "x" ; $CalRepJourG.text = $calendar.SelectionStart.day ; 
# $CalRepMoisG.text = (Get-Culture).DateTimeFormat.GetMonthName($calendar.SelectionStart.month) ; 
$CalRepMoisG.text = $table_mois[[int]($calendar.SelectionStart.month)]
$CalRepAnG.text = $calendar.SelectionStart.year ; $CalRepModifG.text = "y" 
$CalRepModifR.text = "x" ; $CalRepJourR.text = "" ; $CalRepMoisR.text = "" ; $CalRepAnR.text = "" ; $CalRepModifR.text = "y"
}
})

############################# boutons Source, Affich, OK 
$CalRepSource     = New-Object System.Windows.Forms.Button -Property @{Location = "10, 245" ; width = "90" ; Text = $table_lib[6]}
$CalRepSource.add_Click({Start-Process "https://fr.geneawiki.com/index.php?title=Convertir_une_date_rpublicaine_en_date_grgorienne_sur_Excel"})
$CalRepForm.Controls.Add($CalRepSource)
$CalRepToolTip.SetToolTip($CalRepSource, "https://fr.geneawiki.com/index.php?title=Convertir_une_date_rpublicaine_en_date_grgorienne_sur_Excel")

$CalRepAffich      = New-Object System.Windows.Forms.Button -Property @{Location = "180, 245" ; width = "120" ; Text = $table_lib[8]}
$CalRepAffich.add_Click({
if ($CalRepAffich.text -eq $table_lib[8]) {
$CalRepForm.height = 150 ; $CalRepAffich.text = $table_lib[9]
$CalRepAffich.Location = "180, 75" ; $CalRepSource.Location = "10, 75" ; $CalRepOK.Location = "340, 75"
$calendar.Location = "108, 155"} else {
$CalRepForm.height = 320 ; $CalRepAffich.text = $table_lib[8]
$CalRepAffich.Location = "180, 245" ; $CalRepSource.Location = "10, 245" ; $CalRepOK.Location = "340, 245"
$calendar.Location = "108, 75"}
})
$CalRepForm.Controls.Add($CalRepAffich)

$CalRepOK      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 245" ; Text = "OK"}
$CalRepOK.add_Click({$CalRepForm.visible = $false}) ; $CalRepForm.Controls.Add($CalRepOK)
$CalRepForm.CancelButton  = $CalRepOK

####################################################################################################
# calendrier rpublicain : fonctions
function calrep {
$CalRepForm.visible = $true
$x = $ecran.width - 500 ; $y = 80
$CalRepForm.location = new-object System.Drawing.Point $x,$y
} 

function modifr {
if ($CalRepModifR.text -eq "y") {
$CalRepModifG.text = "x" ; $CalRepJourG.text = "" ; $CalRepMoisG.text = "" ; $CalRepAnG.text = "" ; $CalRepModifG.text = "y" ; $calendar.visible = $false}
} 

function modifg {
if ($CalRepModifG.text -eq "y") {$CalRepModifR.text = "x" ; $CalRepJourR.text = "" ; $CalRepMoisR.text = "" ; $CalRepAnR.text = "" ; $CalRepModifR.text = "y" 
if ($CalRepJourG.text -ne "" -and $CalRepMoisG.text -ne "" -and $CalRepAnG.text -ne "") { 
for($i = 1;$i -lt 13;$i++){if ($CalRepMoisG.text -eq $table_mois[$i]) {break} }
$date = $CalRepJourG.text + "/" + $i + "/" + $CalRepAnG.text
if ([string]$date -as [DateTime]) {
$dateM = new-object System.DateTime($CalRepAnG.text, $i, $CalRepJourG.text)
if ($dateM -ge $calendar.MinDate -and $dateM -le $calendar.MaxDate) {$Calendar.name ='x' ; $calendar.SelectionStart = $dateM ; $Calendar.name ="y" ; $calendar.visible = $true} else {$calendar.visible = $false}
} else {$calendar.visible = $false}} else {$calendar.visible = $false}
} 
}

function RversG {
if ($CalRepJourR.text -match "^[\d\.]+$") {
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select date_evt,jour,mois,an,
case when mois = 'erreur' then 'erreur-m' when an = 'erreur' then 'erreur-a' 
when mois = 13 and jour not in ('1','2','3','4','5','6') then 'erreur-c'
when mois = 13 and jour = '6' and an not in (3,7,11) then 'erreur-cc'
when jour not in ('01','02','03','04','05','06','07','08','09','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30') then 'erreur-j'
when (an*1461)/4 + (mois - 1)*30 + jour - 5213 > 0 then 'erreur-HC'
else strftime('%Y/%m/%d',(an*1461)/4 + (mois - 1)*30 + jour + 2375474) end dateG,
(an*1461)/4 + (mois - 1)*30 + jour + 2375474 j
from (select date_evt,jour,
case
when upper(replace(m,'','e')) in ('1','VEND','VENDE','VENDEM','VENDEMI','VENDEMIA','VENDEMIAI','VENDEMIAIR','VENDEMIAIRE') then 1
when upper(m) in ('2','B','BR','BRU','BRUM','BRUMA','BRUMAI','BRUMAIR','BRUMAIRE') then 2
when upper(m) in ('3','FRI','FRIM','FRIMA','FRIMAI','FRIMAIR','FRIMAIRE') then 3
when upper(replace(m,'','o')) in ('4','N','NI','NIV','NIVO','NIVOS','NIVOSE') then 4
when upper(replace(m,'','o')) in ('5','PL','PLU','PLUV','PLUVI','PLUVIO','PLUVIOS','PLUVIOSE') then 5
when upper(replace(m,'','o')) in ('6','VENT','VENTO','VENTOS','VENTOSE') then 6
when upper(m) in ('7','G','GE','GER','GERM','GERMI','GERMIN','GERMINA','GERMINAL') then 7
when upper(replace(m,'','e')) in ('8','FL','FLO','FLOR','FLORE','FLOREA','FLOREAL') then 8
when upper(m) in ('9','PR','PRA','PRAI','PRAIR','PRAIRI','PRAIRIA','PRAIRIAL') then 9
when upper(m) in ('10','ME','MES','MESS','MESSI','MESSID','MESSIDO','MESSIDOR') then 10
when upper(m) in ('11','T','TH','THE','THER','THERM','THERMI','THERMID','THERMIDO','THERMIDOR') then 11
when upper(m) in ('12','FRU','FRUC','FRUCT','FRUCTI','FRUCTID','FRUCTIDO','FRUCTIDOR') then 12
when upper(replace(m,'','e')) in ('13','C','CO','COM','COM','COMP','COMPL','COMPLE','COMPLEM','COMPLEM','COMPLEME','COMPLEMEN','COMPLEMENT','COMPLEMENTA','COMPLEMENTAI','COMPLEMENTAIR','COMPLEMENTAIRE') then 13
else 'erreur' end mois,
case when an in ('I','an I','an 1','1') then 1 when an in ('II','an II','an 2','2') then 2 when an in ('III','an III','an 3','3') then 3 when an in ('IV','an IV','an 4','4') then 4 
when an in ('V','an V','an 5','5') then 5 when an in ('VI','an VI','an 6','6') then 6 when an in ('VII','an VII','an 7','7') then 7 when an in ('VIII','an VIII','an 8','8') then 8 
when an in ('IX','an IX','an 9','9') then 9 when an in ('X','an X','an 10','10') then 10 when an in ('XI','an XI','an 11','11') then 11 when an in ('XII','an XII','an 12','12') then 12 
when an in ('XIII','an XIII','an 13','13') then 13 when an in ('XIV','an XIV','an 14','14') then 14 else 'erreur' end an from 
(select date_evt,substr(date_evt,1,instr(date_evt,' ') - 1)jour,
substr(date_evt,instr(date_evt,' ')+1,instr(substr(date_evt,instr(date_evt,' ')+1),' ') - 1) m,
substr(date_evt,instr(date_evt,' ') + instr(substr(date_evt,instr(date_evt,' ')+1),' ') + 1) an
from (select '" + $CalRepJourR.text + " " + $CalRepMoisR.text + " " + $CalRepAnR.text + "' date_evt)
))
")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) { $dateG = $lecture.getValue(4) }
$lecture.Close()
$cmd.Dispose()

$CalRepModifG.text = "x"
$Calendar.name = "x"
if ($dateg.substring(0,6) -eq "erreur") {$CalRepJourG.text = "" ; $CalRepMoisG.text = "" ; $CalRepAnG.text = ""
$calendar.visible = $false
} else {
$CalRepJourG.text = $dateg.substring(8,2).trimstart("0")
$CalRepMoisG.text = $table_mois[[int]$dateg.substring(5,2)]
$CalRepAnG.text = $dateg.substring(0,4)
for($i = 1;$i -lt 13;$i++){if ($CalRepMoisG.text -eq $table_mois[$i]) {break} }
$calendar.SelectionStart = new-object System.DateTime($CalRepAnG.text, $i, $CalRepJourG.text) 
$calendar.visible = $true
}
$CalRepModifG.text = "y"
$Calendar.name = "y"
}
} 

#  strftime('%J', date_evt) julien, ne rend pas d'erreur pour une date inexistante (il donne la mme valeur pour le 31 avril et le 1er mai)
#  on teste ce cas en faisant l'opration inverse : strftime('%Y-%m-%d %H:%M',julien)

function GversR {
if ($CalRepJourG.text -match "^[\d\.]+$" -and $CalRepAnG.text -match "^[\d\.]+$") {
$CalRepMG = "00"
for($i = 1;$i -lt 13;$i++){if ($CalRepMoisG.text -eq $table_mois[$i]) {$j = [string]$i ; $CalRepMG = $j.padleft(2,"0")} }
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select case when julien < 2375840 or julien > 2380707 or julien is null then 'erreur' when date_evt <> strftime('%Y-%m-%d %H:%M',julien) then 'erreur-bug' else jourR||' '||moisR||' '||anR end dateR, jourR, moisR, anR
from (select date_evt, julien, numja - (30*((numja-1)/30)) jourR,
case ((numja-1)/30) + 1 when 1 then 'Vendmiaire' when 2 then 'Brumaire' when 3 then 'Frimaire' when 4 then 'Nivse' when 5 then 'Pluvise' when 6 then 'Ventse' 
when 7 then 'Germinal' when 8 then 'Floral' when 9 then 'Prairial' when 10 then 'Messidor' when 11 then 'Thermidor' when 12 then 'Fructidor' when 13 then 'Complmentaire' end moisR, 
case numa when 1 then 'an I' when 2 then 'an II' when 3 then 'an III' when 4 then 'an IV' when 5 then 'an V' when 6 then 'an VI' when 7 then 'an VII' when 8 then 'an VIII' when 9 then 'an IX'
when 10 then 'an X' when 11 then 'an XI' when 12 then 'an XII' when 13 then 'an XIII' when 14 then 'an XIV' end anR
from (select date_evt, julien, case when nj = 0 then 365 when j in (1096, 2557, 4018) then 366 else nj end numja, case when j in (1096, 2557, 4018) then na - 1 else na end numa
from (select date_evt, julien, j, (j-sextile) - 365*((j-sextile)/365) nj, 1 + ((j -1 -sextile)/365)  na
from (select date_evt, julien, j, ((j-1+365)/1461)sextile
from (select date_evt, cast(strftime('%J', date_evt) as integer) julien, cast(strftime('%J', date_evt) - 2375839 as integer) j
from (select '" + $CalRepAnG.text + "-" + $CalRepMG + "-" + (""+$CalRepJourG.text).padleft(2,"0") + " 12:00' date_evt)
)))))
")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) { $dateR = $lecture.getValue(0) ; $jourR = $lecture.getValue(1) ; $moisR = $lecture.getValue(2) ; $anR = $lecture.getValue(3)}
$lecture.Close()
$cmd.Dispose()

$CalRepModifR.text = "x"
if ($dater.substring(0,6) -eq "erreur") {$CalRepJourR.text = "" ; $CalRepMoisR.text = "" ; $CalRepAnR.text = ""} else {
$CalRepJourR.text = $jourR
$CalRepMoisR.text = $moisR
$CalRepAnR.text = $anR
}
$CalRepModifR.text = "y"

}
} 

####################################################################################################
#
# Affichage
#
####################################################################################################

$consolePtr = [Console.Window]::GetConsoleWindow()
[Console.Window]::ShowWindow($consolePtr, 0)

$CalRepForm.showdialog()

$CalRepForm.close
if ($global:conn_mem.state -eq "Open") {$global:conn_mem.close()}
if ($global:conn_mem.state -eq "Closed") {$global:conn_mem.dispose()}


